//
//  GSLayer+ImportOutlines.h
//  GlyphsCore
//
//  Created by Georg Seifert on 17.05.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSLayer (ImportOutlines)

+ (BOOL)canImportOutlinesFromFile:(NSString *)fileName;

+ (BOOL)canImportOutlinesFromURL:(NSURL *)fileURL;

- (BOOL)importOutlinesFromURL:(NSURL *)fileURL scale:(CGFloat)scale error:(out NSError **)error;

#ifndef GLYPHS_LITE
- (void)scaleToFullHeight:(GSGlyphMetrics)layerMetrics bounds:(NSRect)bounds;
#endif

@end

NS_ASSUME_NONNULL_END
